/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.shape;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import snownee.kiwi.customization.shape.AbstractHorizontalShape;
import snownee.kiwi.customization.shape.BakingContext;
import snownee.kiwi.customization.shape.ShapeGenerator;
import snownee.kiwi.customization.shape.UnbakedShape;
import snownee.kiwi.customization.shape.UnbakedShapeCodec;
import snownee.kiwi.util.VoxelUtil;

public record FrontAndTopShape(ShapeGenerator floor, ShapeGenerator ceiling, ShapeGenerator wall) implements ShapeGenerator
{
    public static ShapeGenerator create(ShapeGenerator floor, ShapeGenerator ceiling, ShapeGenerator wall) {
        return new FrontAndTopShape(Child.create(floor), Child.create(ceiling), Child.create(wall));
    }

    @Override
    public VoxelShape getShape(BlockState blockState, CollisionContext context) {
        FrontAndTop frontAndTop = (FrontAndTop)blockState.getValue((Property)BlockStateProperties.ORIENTATION);
        return switch (frontAndTop.front()) {
            case Direction.UP -> this.ceiling.getShape(blockState, context);
            case Direction.DOWN -> this.floor.getShape(blockState, context);
            default -> this.wall.getShape(blockState, context);
        };
    }

    public record Child(VoxelShape[] shapes) implements AbstractHorizontalShape
    {
        public static ShapeGenerator create(ShapeGenerator northGenerator) {
            VoxelShape north = ShapeGenerator.Unit.unboxOrThrow(northGenerator);
            if (VoxelUtil.isIsotropicHorizontally(north)) {
                return northGenerator;
            }
            VoxelShape[] shapes = new VoxelShape[4];
            shapes[Direction.NORTH.get2DDataValue()] = north;
            return new Child(shapes);
        }

        @Override
        public Direction getDirection(BlockState blockState) {
            FrontAndTop frontAndTop = (FrontAndTop)blockState.getValue((Property)BlockStateProperties.ORIENTATION);
            return frontAndTop.top().getAxis().isHorizontal() ? frontAndTop.top() : frontAndTop.front();
        }
    }

    public record Unbaked(UnbakedShape floor, UnbakedShape ceiling, UnbakedShape wall) implements UnbakedShape
    {
        public static Codec<Unbaked> codec(UnbakedShapeCodec parentCodec) {
            return RecordCodecBuilder.create(instance -> instance.group((App)parentCodec.fieldOf("floor").forGetter(Unbaked::floor), (App)parentCodec.fieldOf("ceiling").forGetter(Unbaked::ceiling), (App)parentCodec.fieldOf("wall").forGetter(Unbaked::wall)).apply((Applicative)instance, Unbaked::new));
        }

        @Override
        public ShapeGenerator bake(BakingContext context) {
            return FrontAndTopShape.create(this.floor.bake(context), this.ceiling.bake(context), this.wall.bake(context));
        }

        @Override
        public Stream<UnbakedShape> dependencies() {
            return Stream.of(this.floor, this.ceiling, this.wall);
        }
    }
}

