/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.recipe;

import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.recipe.CustomIngredient;
import snownee.kiwi.recipe.CustomIngredientSerializer;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record CustomIngredientImpl<T extends CustomIngredient>(T ingredient) implements ICustomIngredient
{
    static final Map<ResourceLocation, CustomIngredientSerializer<?>> REGISTERED_SERIALIZERS = new ConcurrentHashMap();
    private static final Map<CustomIngredientSerializer<?>, IngredientType<?>> INGREDIENT_TYPES = Maps.newIdentityHashMap();

    @SubscribeEvent
    private static void onRegister(RegisterEvent event) {
        event.register(NeoForgeRegistries.INGREDIENT_TYPES.key(), helper -> INGREDIENT_TYPES.forEach((serializer, type) -> helper.register(serializer.getIdentifier(), type)));
    }

    public static void registerSerializer(CustomIngredientSerializer<?> serializer) {
        Objects.requireNonNull(serializer.getIdentifier(), "CustomIngredientSerializer identifier may not be null.");
        if (REGISTERED_SERIALIZERS.putIfAbsent(serializer.getIdentifier(), serializer) != null) {
            throw new IllegalArgumentException("CustomIngredientSerializer with identifier " + String.valueOf(serializer.getIdentifier()) + " already registered.");
        }
        INGREDIENT_TYPES.put(serializer, CustomIngredientImpl.makeSerializer(serializer));
    }

    private static <T extends CustomIngredient> IngredientType<CustomIngredientImpl<T>> makeSerializer(CustomIngredientSerializer<T> serializer) {
        MapCodec codec = serializer.getCodec(true).xmap(CustomIngredientImpl::new, CustomIngredientImpl::ingredient);
        StreamCodec streamCodec = serializer.getPacketCodec().map(CustomIngredientImpl::new, CustomIngredientImpl::ingredient);
        return new IngredientType(codec, streamCodec);
    }

    @Nullable
    public static CustomIngredientSerializer<?> getSerializer(ResourceLocation identifier) {
        Objects.requireNonNull(identifier, "Identifier may not be null.");
        return REGISTERED_SERIALIZERS.get(identifier);
    }

    public boolean test(ItemStack itemStack) {
        return this.ingredient.test(itemStack);
    }

    public Stream<ItemStack> getItems() {
        return this.ingredient.getMatchingStacks().stream();
    }

    public boolean isSimple() {
        return !this.ingredient.requiresTesting();
    }

    public IngredientType<?> getType() {
        return Objects.requireNonNull(INGREDIENT_TYPES.get(this.ingredient.getSerializer()));
    }
}

