/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.gui.containerfactory;

import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.blocks.tileentity.PipeLogicTileEntity;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class FilterContainerProvider
implements MenuProvider {
    private ContainerCreator container;
    private PipeLogicTileEntity pipe;

    public FilterContainerProvider(ContainerCreator container, PipeLogicTileEntity pipe) {
        this.container = container;
        this.pipe = pipe;
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.pipe.getBlockState().getBlock().getDescriptionId());
    }

    public static void openGui(Player player, PipeLogicTileEntity tileEntity, Direction direction, Filter<?, ?> filter, int index, ContainerCreator containerCreator) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.openMenu((MenuProvider)new FilterContainerProvider(containerCreator, tileEntity), packetBuffer -> {
                packetBuffer.writeBlockPos(tileEntity.getBlockPos());
                packetBuffer.writeEnum((Enum)direction);
                packetBuffer.writeInt(index);
                filter.toNetwork((RegistryFriendlyByteBuf)packetBuffer);
            });
        }
    }

    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return this.container.create(i, playerInventory, playerEntity);
    }

    public static interface ContainerCreator {
        public AbstractContainerMenu create(int var1, Inventory var2, Player var3);
    }
}

