/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui.button;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.button.GuiButtonBook;
import vazkii.patchouli.common.book.Book;

public class GuiButtonBookBookmark
extends GuiButtonBook {
    private final Book book;
    public final PersistentData.Bookmark bookmark;
    public final boolean multiblock;

    public GuiButtonBookBookmark(GuiBook parent, int x, int y, PersistentData.Bookmark bookmark) {
        this(parent, x, y, bookmark, false);
    }

    public GuiButtonBookBookmark(GuiBook parent, int x, int y, PersistentData.Bookmark bookmark, boolean multiblock) {
        super(parent, x, y, 272, bookmark == null ? 170 : 160, 13, 10, parent::handleButtonBookmark, GuiButtonBookBookmark.getTooltip(parent.book, bookmark, multiblock));
        this.book = parent.book;
        this.bookmark = bookmark;
        this.multiblock = multiblock;
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        BookEntry entry;
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        BookEntry bookEntry = entry = this.bookmark == null ? null : this.bookmark.getEntry(this.book);
        if (this.bookmark != null && entry != null) {
            graphics.pose().pushPose();
            graphics.pose().scale(0.5f, 0.5f, 0.5f);
            int px = this.getX() * 2 + (this.isHoveredOrFocused() ? 6 : 2);
            int py = this.getY() * 2 + 2;
            entry.getIcon().render(graphics, px, py);
            RenderSystem.disableDepthTest();
            String s = Integer.toString(this.bookmark.spread + 1);
            if (this.multiblock) {
                s = I18n.get((String)"patchouli.gui.lexicon.visualize_letter", (Object[])new Object[0]);
            }
            graphics.drawString(this.parent.getMinecraft().font, s, px + 12, py + 10, 0xFFFFFF, true);
            RenderSystem.enableDepthTest();
            graphics.pose().popPose();
        }
    }

    private static Component[] getTooltip(Book book, PersistentData.Bookmark bookmark, boolean multiblock) {
        BookEntry entry;
        BookEntry bookEntry = entry = bookmark == null ? null : bookmark.getEntry(book);
        if (bookmark == null || entry == null) {
            return new Component[]{Component.translatable((String)"patchouli.gui.lexicon.add_bookmark")};
        }
        return new Component[]{entry.getName(), Component.translatable((String)(multiblock ? "patchouli.gui.lexicon.multiblock_bookmark" : "patchouli.gui.lexicon.remove_bookmark")).withStyle(ChatFormatting.GRAY)};
    }
}

