/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.mehvahdjukaar.snowyspirit.client.GingyModel;
import net.mehvahdjukaar.snowyspirit.common.entity.GingyEntity;
import net.mehvahdjukaar.snowyspirit.reg.ClientRegistry;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;

public class GingyEntityRenderer
extends HumanoidMobRenderer<GingyEntity, GingyModel> {
    private static final Map<DyeColor, ResourceLocation> GINGY_TEXTURES = Arrays.stream(DyeColor.values()).collect(Collectors.toMap(Function.identity(), d -> SnowySpirit.res("textures/entity/gingerbread_golem/" + d.getName() + ".png")));
    private final float scale;

    public GingyEntityRenderer(EntityRendererProvider.Context context, float scale) {
        super(context, (HumanoidModel)new GingyModel(context.bakeLayer(ClientRegistry.GINGY_MODEL), scale), 0.25f * scale);
        this.scale = scale;
    }

    protected void scale(GingyEntity livingEntity, PoseStack matrixStack, float partialTickTime) {
        matrixStack.scale(this.scale, this.scale, this.scale);
    }

    protected float getFlipDegrees(GingyEntity livingEntity) {
        return 0.0f;
    }

    public ResourceLocation getTextureLocation(GingyEntity entity) {
        return GINGY_TEXTURES.get(entity.getColor());
    }

    protected void setupRotations(GingyEntity entity, PoseStack poseStack, float bob, float yBodyRot, float partialTicks, float scale) {
        super.setupRotations((LivingEntity)entity, poseStack, bob, yBodyRot, partialTicks, this.scale);
        if (entity.deathTime > 0) {
            float f = ((float)entity.deathTime + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.sqrt((float)f)) > 1.0f) {
                f = 1.0f;
            }
            int deg = entity.isForwardDeathAnim() ? -90 : 90;
            poseStack.mulPose(Axis.XP.rotationDegrees(f * (float)deg));
        }
        float period = 7.853982f * this.scale;
        float limbSwingAmount = 0.0f;
        float walkAnim = 0.0f;
        boolean orderedToSit = entity.isOrderedToSit();
        if (orderedToSit) {
            poseStack.translate(0.0, -0.25, 0.0);
        }
        if (!orderedToSit && entity.isAlive()) {
            float maxLimbSwing;
            limbSwingAmount = entity.walkAnimation.speed(partialTicks);
            walkAnim = entity.walkAnimation.position(partialTicks);
            if (entity.isBaby()) {
                walkAnim *= 3.0f;
            }
            if (limbSwingAmount > (maxLimbSwing = 1.0f)) {
                limbSwingAmount = maxLimbSwing;
            }
        }
        if ((double)limbSwingAmount > 0.001) {
            float angle = walkAnim * ((float)Math.PI * 2 / period);
            float sideSwayPower = 20.0f / this.scale;
            poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.cos((float)angle) * sideSwayPower * limbSwingAmount));
        }
    }
}

