/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.client;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.mehvahdjukaar.snowyspirit.client.QuiltModel;
import net.mehvahdjukaar.snowyspirit.client.SledModel;
import net.mehvahdjukaar.snowyspirit.common.entity.SledEntity;
import net.mehvahdjukaar.snowyspirit.reg.ClientRegistry;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class SledEntityRenderer
extends EntityRenderer<SledEntity> {
    private final Map<WoodType, ResourceLocation> textures;
    private final Map<DyeColor, ResourceLocation> quiltTextures;
    private final SledModel<SledEntity> model;
    private final SledModel<SledEntity> modelBamboo;
    private final QuiltModel<SledEntity> quiltModel;
    public static final WoodType BAMBOO = (WoodType)WoodTypeRegistry.INSTANCE.get(ResourceLocation.tryParse((String)"bamboo"));

    public SledEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.8f;
        this.model = new SledModel(context.bakeLayer(ClientRegistry.SLED_MODEL));
        this.modelBamboo = new SledModel(context.bakeLayer(ClientRegistry.SLED_MODEL_BAMBOO));
        this.quiltModel = new QuiltModel(context.bakeLayer(ClientRegistry.QUILT_MODEL));
        this.textures = (Map)WoodTypeRegistry.INSTANCE.getValues().stream().collect(ImmutableMap.toImmutableMap(e -> e, t -> SnowySpirit.res("textures/entity/sled/" + t.getTexturePath() + ".png")));
        this.quiltTextures = (Map)Stream.of(DyeColor.values()).collect(ImmutableMap.toImmutableMap(e -> e, t -> SnowySpirit.res("textures/entity/sled/quilt/" + t.getName() + ".png")));
    }

    public void render(SledEntity sled, float yRot, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        double dy = Mth.lerp((double)partialTicks, (double)sled.prevAdditionalY, (double)sled.cachedAdditionalY);
        poseStack.pushPose();
        poseStack.translate(0.0, 0.375 + dy, 0.0);
        float xRot = sled.getViewXRot(partialTicks);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - yRot));
        poseStack.mulPose(Axis.XN.rotationDegrees(xRot));
        float hurtTme = (float)sled.getHurtTime() - partialTicks;
        float damage = sled.getDamage() - partialTicks;
        if (damage < 0.0f) {
            damage = 0.0f;
        }
        float zRot = 0.0f;
        if (hurtTme > 0.0f) {
            zRot = Mth.sin((float)hurtTme) * hurtTme * damage / 10.0f * (float)sled.getHurtDir();
            poseStack.mulPose(Axis.ZP.rotationDegrees(zRot));
        }
        poseStack.pushPose();
        poseStack.translate(0.0, 0.125, 0.4);
        poseStack.scale(0.75f, 0.75f, 0.75f);
        poseStack.translate(-0.5, 0.0, -0.5);
        poseStack.popPose();
        ResourceLocation resourcelocation = this.getTextureLocation(sled);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        VertexConsumer vertexconsumer = bufferSource.getBuffer(this.model.renderType(resourcelocation));
        SledModel<SledEntity> mod = this.getModel(sled);
        mod.renderToBuffer(poseStack, vertexconsumer, light, OverlayTexture.NO_OVERLAY, -1);
        DyeColor color = sled.getSeatType();
        if (color != null) {
            vertexconsumer = bufferSource.getBuffer(this.model.renderType(this.quiltTextures.get(color)));
            this.quiltModel.renderToBuffer(poseStack, vertexconsumer, light, OverlayTexture.NO_OVERLAY, -1);
        }
        poseStack.popPose();
        this.renderLeash(sled, partialTicks, poseStack, bufferSource, (float)Math.toRadians(90.0f + yRot), (float)Math.toRadians(xRot), (float)Math.toRadians(zRot), dy);
        super.render((Entity)sled, yRot, partialTicks, poseStack, bufferSource, light);
        if (this.entityRenderDispatcher.shouldRenderHitBoxes()) {
            this.renderDebugHitbox(poseStack, bufferSource.getBuffer(RenderType.lines()), sled, partialTicks);
        }
    }

    public ResourceLocation getTextureLocation(SledEntity sled) {
        return this.textures.get(sled.getWoodType());
    }

    public SledModel<SledEntity> getModel(SledEntity sled) {
        return sled.getWoodType() == BAMBOO ? this.modelBamboo : this.model;
    }

    private void renderDebugHitbox(PoseStack pMatrixStack, VertexConsumer pBuffer, SledEntity pEntity, float pPartialTicks) {
        AABB aabb = pEntity.getBoundingBox().move(SledEntityRenderer.lerpV(pPartialTicks, pEntity.prevProjectedPos, pEntity.projectedPos)).move(-pEntity.getX(), -pEntity.getY(), -pEntity.getZ());
        LevelRenderer.renderLineBox((PoseStack)pMatrixStack, (VertexConsumer)pBuffer, (AABB)aabb, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (pEntity.hasPuller()) {
            aabb = pEntity.pullerAABB.move(-pEntity.getX(), -pEntity.getY(), -pEntity.getZ());
            LevelRenderer.renderLineBox((PoseStack)pMatrixStack, (VertexConsumer)pBuffer, (AABB)aabb, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        }
        Vec3 movement = SledEntityRenderer.lerpV(pPartialTicks, pEntity.prevDeltaMovement, pEntity.getDeltaMovement());
        PoseStack.Pose pose = pMatrixStack.last();
        float mult = 6.0f;
        float eye = pEntity.getEyeHeight() + 1.0f + pEntity.cachedAdditionalY;
        pBuffer.addVertex(pose, 0.0f, eye, 0.0f).setColor(0, 255, 0, 255).setNormal(pose, (float)movement.x, (float)movement.y, (float)movement.z);
        pBuffer.addVertex(pose, (float)(movement.x * (double)mult), (float)((double)eye + movement.y * (double)mult), (float)(movement.z * (double)mult)).setColor(0, 255, 0, 255).setNormal(pose, (float)movement.x, (float)movement.y, (float)movement.z);
        pBuffer.addVertex(pose, 0.0f, eye + 0.25f, 0.0f).setColor(255, 0, 255, 255).setNormal(pose, 0.0f, 1.0f, 0.0f);
        pBuffer.addVertex(pose, 0.0f, (float)((double)(eye + 0.25f) + pEntity.misalignedFrictionFactor), 0.0f).setColor(255, 0, 255, 255).setNormal(pose, 0.0f, 1.0f, 0.0f);
        if (pEntity.boost) {
            movement = movement.normalize().scale(-1.0);
            pBuffer.addVertex(pose, 0.0f, eye, 0.0f).setColor(255, 255, 0, 255).setNormal(pose, (float)movement.x, (float)movement.y, (float)movement.z);
            pBuffer.addVertex(pose, (float)movement.x, (float)((double)eye + movement.y), (float)movement.z).setColor(255, 255, 0, 255).setNormal(pose, (float)movement.x, (float)movement.y, (float)movement.z);
        }
    }

    public static Vec3 lerpV(float delta, Vec3 start, Vec3 end) {
        return new Vec3(Mth.lerp((double)delta, (double)start.x, (double)end.x), Mth.lerp((double)delta, (double)start.y, (double)end.y), Mth.lerp((double)delta, (double)start.z, (double)end.z));
    }

    private void renderLeash(SledEntity sled, float pPartialTicks, PoseStack poseStack, MultiBufferSource pBuffer, float yRot, float xRot, float zRot, double addY) {
        Animal wolf = sled.getSledPuller();
        if (wolf != null) {
            boolean bear = Utils.getID((EntityType)wolf.getType()).getPath().equals("grizzly_bear");
            Vec3 wolfPos = wolf.getRopeHoldPosition(pPartialTicks).add(0.0, wolf.isBaby() ? 0.1 : 0.25, 0.0);
            float bbw = wolf.getBbWidth() / (2.875f + (bear ? 1.5f : 0.0f));
            Vec3 sledOffset = new Vec3((double)0.4125f, 0.0, (double)0.95f);
            Vec3 ropeOffset = new Vec3((double)bbw, 0.0, 0.0);
            float cos = Mth.cos((float)yRot);
            float sin = Mth.sin((float)yRot);
            float pCos = Mth.cos((float)xRot);
            float pSin = Mth.sin((float)xRot);
            float wSin = Mth.sin((float)zRot);
            double sledX = Mth.lerp((double)pPartialTicks, (double)sled.xo, (double)sled.getX());
            double sledY = Mth.lerp((double)pPartialTicks, (double)sled.yo, (double)sled.getY());
            double sledZ = Mth.lerp((double)pPartialTicks, (double)sled.zo, (double)sled.getZ());
            BlockPos sledEyePos = BlockPos.containing((Position)sled.getEyePosition(pPartialTicks));
            BlockPos wolfEyePos = BlockPos.containing((Position)wolf.getEyePosition(pPartialTicks));
            for (int rope = -1; rope <= 1; rope += 2) {
                int index;
                VertexConsumer vertexconsumer = pBuffer.getBuffer(RenderType.leash());
                poseStack.pushPose();
                double wolfOffsetX = (double)cos * ropeOffset.z + (double)sin * ropeOffset.x * (double)rope;
                double wolfOffsetZ = (double)sin * ropeOffset.z - (double)cos * ropeOffset.x * (double)rope;
                double offsetX = ((double)cos * sledOffset.z + (double)sin * sledOffset.x * (double)rope) * (double)pCos;
                double offsetZ = ((double)sin * sledOffset.z - (double)cos * sledOffset.x * (double)rope) * (double)pCos;
                double offsetY = (double)(-pSin) * sledOffset.length() + 0.25 + addY - sledOffset.x * (double)wSin * (double)rope;
                double pX = sledX + offsetX;
                double pY = sledY + offsetY;
                double pZ = sledZ + offsetZ;
                poseStack.translate(offsetX, offsetY, offsetZ);
                float deltaX = (float)(wolfPos.x + wolfOffsetX - pX);
                float deltaY = (float)(wolfPos.y - pY);
                float deltaZ = (float)(wolfPos.z + wolfOffsetZ - pZ);
                float width = 0.025f;
                Matrix4f matrix4f = poseStack.last().pose();
                float f4 = Mth.invSqrt((float)(deltaX * deltaX + deltaZ * deltaZ)) * width / 2.0f;
                float mathZ = deltaZ * f4;
                float mathX = deltaX * f4;
                int blockLight0 = this.getBlockLightLevel(sled, sledEyePos);
                Level level = wolf.level();
                int blockLight1 = wolf.isOnFire() ? 15 : level.getBrightness(LightLayer.BLOCK, wolfEyePos);
                int skyLight0 = level.getBrightness(LightLayer.SKY, sledEyePos);
                int skyLight1 = level.getBrightness(LightLayer.SKY, wolfEyePos);
                int maxSegments = 12;
                for (index = 0; index <= maxSegments; ++index) {
                    SledEntityRenderer.addVertexPair(vertexconsumer, matrix4f, deltaX, deltaY, deltaZ, blockLight0, blockLight1, skyLight0, skyLight1, 0.025f, 0.025f, mathZ, mathX, index, false, maxSegments);
                }
                for (index = maxSegments; index >= 0; --index) {
                    SledEntityRenderer.addVertexPair(vertexconsumer, matrix4f, deltaX, deltaY, deltaZ, blockLight0, blockLight1, skyLight0, skyLight1, 0.025f, 0.0f, mathZ, mathX, index, true, maxSegments);
                }
                poseStack.popPose();
                if (!(pBuffer instanceof MultiBufferSource.BufferSource)) continue;
                MultiBufferSource.BufferSource bu = (MultiBufferSource.BufferSource)pBuffer;
                bu.endBatch();
            }
        }
    }

    private static void addVertexPair(VertexConsumer vertexConsumer, Matrix4f matrix4f, float startX, float startY, float startZ, int blockLight0, int blockLight1, int skyLight0, int skyLight1, float y0, float y1, float dx, float dz, int index, boolean flippedColors, int maxSegments) {
        float segment = (float)index / (float)maxSegments;
        int i = (int)Mth.lerp((float)segment, (float)blockLight0, (float)blockLight1);
        int j = (int)Mth.lerp((float)segment, (float)skyLight0, (float)skyLight1);
        int light = LightTexture.pack((int)i, (int)j);
        float darker = index % 2 == (flippedColors ? 1 : 0) ? 0.7f : 1.0f;
        float red = 0.5f * darker;
        float green = 0.4f * darker;
        float blue = 0.3f * darker;
        float sx = startX * segment;
        float sy = startY > 0.0f ? startY * segment * segment : startY - startY * (1.0f - segment) * (1.0f - segment);
        float sz = startZ * segment;
        vertexConsumer.addVertex(matrix4f, sx - dx, sy + y1, sz + dz).setColor(red, green, blue, 1.0f).setLight(light);
        vertexConsumer.addVertex(matrix4f, sx + dx, sy + y0 - y1, sz - dz).setColor(red, green, blue, 1.0f).setLight(light);
    }
}

