/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.ai;

import java.util.EnumSet;
import net.mehvahdjukaar.snowyspirit.common.entity.GingyEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class GingySitWhenOrderedToGoal
extends Goal {
    private final GingyEntity mob;

    public GingySitWhenOrderedToGoal(GingyEntity tamableAnimal) {
        this.mob = tamableAnimal;
        this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    public boolean canContinueToUse() {
        return this.mob.isOrderedToSit();
    }

    public boolean canUse() {
        if (this.mob.getOwnerUUID() == null) {
            return false;
        }
        if (this.mob.isInWaterOrBubble()) {
            return false;
        }
        if (!this.mob.onGround()) {
            return false;
        }
        LivingEntity livingEntity = this.mob.getOwner();
        if (livingEntity == null) {
            return true;
        }
        return (this.mob.distanceToSqr((Entity)livingEntity) >= 144.0 || livingEntity.getLastHurtByMob() == null) && this.mob.isOrderedToSit();
    }

    public void start() {
        this.mob.getNavigation().stop();
        this.mob.setOrderedToSit(true);
    }

    public void stop() {
        this.mob.setOrderedToSit(false);
    }
}

