/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.mehvahdjukaar.snowyspirit.common.entity.GolemHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class GumdropButton
extends DirectionalBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    protected static final VoxelShape DOWN_AABB = Block.box((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    protected static final VoxelShape UP_AABB = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0);
    protected static final VoxelShape NORTH_AABB = Block.box((double)5.0, (double)5.0, (double)12.0, (double)11.0, (double)11.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.box((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)4.0);
    protected static final VoxelShape WEST_AABB = Block.box((double)12.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);
    protected static final VoxelShape EAST_AABB = Block.box((double)0.0, (double)5.0, (double)5.0, (double)4.0, (double)11.0, (double)11.0);
    protected static final VoxelShape PRESSED_DOWN_AABB = Block.box((double)5.0, (double)14.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    protected static final VoxelShape PRESSED_UP_AABB = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0);
    protected static final VoxelShape PRESSED_NORTH_AABB = Block.box((double)5.0, (double)5.0, (double)14.0, (double)11.0, (double)11.0, (double)16.0);
    protected static final VoxelShape PRESSED_SOUTH_AABB = Block.box((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)2.0);
    protected static final VoxelShape PRESSED_WEST_AABB = Block.box((double)14.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);
    protected static final VoxelShape PRESSED_EAST_AABB = Block.box((double)0.0, (double)5.0, (double)5.0, (double)2.0, (double)11.0, (double)11.0);
    public static final MapCodec<GumdropButton> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)GumdropButton.propertiesCodec(), (App)DyeColor.CODEC.fieldOf("dye_color").forGetter(buttonBlock -> buttonBlock.color)).apply((Applicative)i, GumdropButton::new));
    public final DyeColor color;

    public GumdropButton(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties.mapColor(color));
        this.color = color;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        BlockPos relative = pos.above().relative(((Direction)state.getValue((Property)FACING)).getOpposite());
        BlockState pumpkin = level.getBlockState(relative);
        if (pumpkin.getBlock() instanceof CarvedPumpkinBlock) {
            GolemHelper.trySpawningGingy(pumpkin, (LevelAccessor)level, relative, (Entity)placer);
        }
        GolemHelper.trySpawningMongo(state, level, pos, (Entity)placer);
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        Direction dir = ((Direction)pState.getValue((Property)FACING)).getOpposite();
        BlockPos blockpos = pPos.relative(dir);
        return GumdropButton.canSupportCenter((LevelReader)pLevel, (BlockPos)blockpos, (Direction)dir);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Direction direction = pContext.getClickedFace();
        BlockState blockstate = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
        if (blockstate.canSurvive((LevelReader)pContext.getLevel(), pContext.getClickedPos())) {
            return blockstate;
        }
        return null;
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return ((Direction)pState.getValue((Property)FACING)).getOpposite() == pFacing && !pState.canSurvive((LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    private int getPressDuration() {
        return 40;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        boolean powered = (Boolean)pState.getValue((Property)POWERED);
        return switch ((Direction)pState.getValue((Property)FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.EAST -> {
                if (powered) {
                    yield PRESSED_EAST_AABB;
                }
                yield EAST_AABB;
            }
            case Direction.WEST -> {
                if (powered) {
                    yield PRESSED_WEST_AABB;
                }
                yield WEST_AABB;
            }
            case Direction.SOUTH -> {
                if (powered) {
                    yield PRESSED_SOUTH_AABB;
                }
                yield SOUTH_AABB;
            }
            case Direction.NORTH -> {
                if (powered) {
                    yield PRESSED_NORTH_AABB;
                }
                yield NORTH_AABB;
            }
            case Direction.DOWN -> {
                if (powered) {
                    yield PRESSED_DOWN_AABB;
                }
                yield DOWN_AABB;
            }
            case Direction.UP -> powered ? PRESSED_UP_AABB : UP_AABB;
        };
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult hitResult) {
        if (((Boolean)pState.getValue((Property)POWERED)).booleanValue()) {
            return InteractionResult.CONSUME;
        }
        this.press(pState, pLevel, pPos);
        this.playSound(pPlayer, (LevelAccessor)pLevel, pPos, true);
        pLevel.gameEvent((Entity)pPlayer, (Holder)GameEvent.BLOCK_ACTIVATE, pPos);
        return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
    }

    public void press(BlockState pState, Level pLevel, BlockPos pPos) {
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
        this.updateNeighbours(pState, pLevel, pPos);
        pLevel.scheduleTick(pPos, (Block)this, this.getPressDuration());
    }

    protected void playSound(@Nullable Player pPlayer, LevelAccessor pLevel, BlockPos pPos, boolean pHitByArrow) {
        pLevel.playSound((Player)(pHitByArrow ? pPlayer : null), pPos, this.getSound(pHitByArrow), SoundSource.BLOCKS, 0.3f, pHitByArrow ? 0.6f : 0.5f);
    }

    protected SoundEvent getSound(boolean pIsOn) {
        return pIsOn ? SoundEvents.SLIME_BLOCK_BREAK : SoundEvents.SLIME_BLOCK_STEP;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pIsMoving && !pState.is(pNewState.getBlock())) {
            if (((Boolean)pState.getValue((Property)POWERED)).booleanValue()) {
                this.updateNeighbours(pState, pLevel, pPos);
            }
            super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    public int getSignal(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return (Boolean)pBlockState.getValue((Property)POWERED) != false ? 15 : 0;
    }

    public int getDirectSignal(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return (Boolean)pBlockState.getValue((Property)POWERED) != false && pBlockState.getValue((Property)FACING) == pSide ? 15 : 0;
    }

    public boolean isSignalSource(BlockState pState) {
        return true;
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRand) {
        if (((Boolean)pState.getValue((Property)POWERED)).booleanValue()) {
            this.checkPressed(pState, (Level)pLevel, pPos);
        }
    }

    public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (!pLevel.isClientSide && !((Boolean)pState.getValue((Property)POWERED)).booleanValue()) {
            this.checkPressed(pState, pLevel, pPos);
        }
    }

    private void checkPressed(BlockState pState, Level pLevel, BlockPos pPos) {
        boolean flag1;
        List<Entity> list = pLevel.getEntitiesOfClass(Entity.class, pState.getShape((BlockGetter)pLevel, pPos).bounds().move(pPos)).stream().filter(e -> e instanceof AbstractArrow || e instanceof LivingEntity).toList();
        boolean flag = !list.isEmpty();
        if (flag != (flag1 = ((Boolean)pState.getValue((Property)POWERED)).booleanValue())) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 3);
            this.updateNeighbours(pState, pLevel, pPos);
            this.playSound(null, (LevelAccessor)pLevel, pPos, flag);
            pLevel.gameEvent((Entity)list.stream().findFirst().orElse(null), (Holder)(flag ? GameEvent.BLOCK_ACTIVATE : GameEvent.BLOCK_DEACTIVATE), pPos);
        }
        if (flag) {
            pLevel.scheduleTick(new BlockPos((Vec3i)pPos), (Block)this, this.getPressDuration());
        }
    }

    private void updateNeighbours(BlockState pState, Level pLevel, BlockPos pPos) {
        pLevel.updateNeighborsAt(pPos, (Block)this);
        pLevel.updateNeighborsAt(pPos.relative(((Direction)pState.getValue((Property)FACING)).getOpposite()), (Block)this);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, POWERED});
    }
}

