/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.entity;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.mehvahdjukaar.snowyspirit.common.ai.GingyFollowOwnerGoal;
import net.mehvahdjukaar.snowyspirit.common.ai.GingySitWhenOrderedToGoal;
import net.mehvahdjukaar.snowyspirit.reg.ModRegistry;
import net.mehvahdjukaar.snowyspirit.reg.ModTags;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class GingyEntity
extends AbstractGolem
implements OwnableEntity {
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNER_UUID = SynchedEntityData.defineId(GingyEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    protected static final EntityDataAccessor<Byte> DATA_FLAGS = SynchedEntityData.defineId(GingyEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    protected static final EntityDataAccessor<Integer> DATA_COLOR = SynchedEntityData.defineId(GingyEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final Predicate<LivingEntity> TARGET_SELECTOR = entity -> entity.getType().is(ModTags.GINGY_TARGETS);

    public GingyEntity(EntityType<? extends AbstractGolem> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new GingySitWhenOrderedToGoal(this));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, true));
        this.goalSelector.addGoal(6, (Goal)new GingyFollowOwnerGoal(this, 1.0, 7.0f, 3.5f, false));
        this.goalSelector.addGoal(11, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8, 1.0000001E-5f));
        this.goalSelector.addGoal(12, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, TARGET_SELECTOR));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_FLAGS, (Object)0);
        builder.define(DATA_OWNER_UUID, Optional.empty());
        builder.define(DATA_COLOR, (Object)DyeColor.WHITE.ordinal());
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        DyeColor d = this.getColor();
        compound.putInt("Color", d.getId());
        if (this.getOwnerUUID() != null) {
            compound.putUUID("Owner", this.getOwnerUUID());
        }
        compound.putBoolean("Sitting", this.isOrderedToSit());
        BodyIntegrity bodyIntegrity = this.getBodyIntegrity();
        if (bodyIntegrity != BodyIntegrity.FULL) {
            compound.putInt("Bites", bodyIntegrity.ordinal());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.hasUUID("Owner")) {
            UUID uUID = compound.getUUID("Owner");
            this.setOwnerUUID(uUID);
        }
        if (compound.contains("Color", 99)) {
            this.setColor(DyeColor.byId((int)compound.getInt("Color")));
        }
        this.setOrderedToSit(compound.getBoolean("Sitting"));
        if (compound.contains("Bites", 99)) {
            this.setBodyIntegrity(BodyIntegrity.values()[compound.getInt("Bites")]);
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setColor(DyeColor.values()[level.getRandom().nextInt(DyeColor.values().length)]);
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public boolean isSensitiveToWater() {
        return true;
    }

    public DyeColor getColor() {
        return DyeColor.byId((int)((Integer)this.entityData.get(DATA_COLOR)));
    }

    public void setColor(DyeColor collarColor) {
        this.entityData.set(DATA_COLOR, (Object)collarColor.getId());
    }

    public boolean isForwardDeathAnim() {
        return ((Byte)this.entityData.get(DATA_FLAGS) & 0x80) >> 7 == 1;
    }

    public void setForwardDeathAnim(boolean forward) {
        byte b = (Byte)this.entityData.get(DATA_FLAGS);
        this.entityData.set(DATA_FLAGS, (Object)((byte)(b & 0x7F | (forward ? 1 : 0) << 7)));
    }

    public BodyIntegrity getBodyIntegrity() {
        return BodyIntegrity.values()[((Byte)this.entityData.get(DATA_FLAGS) & 0xE) >> 1];
    }

    public boolean increaseIntegrity() {
        BodyIntegrity b = this.getBodyIntegrity();
        BodyIntegrity[] values = BodyIntegrity.values();
        int ind = b.ordinal();
        if (ind > 0) {
            this.setBodyIntegrity(values[ind - 1]);
            return true;
        }
        return false;
    }

    public boolean decreaseIntegrity() {
        BodyIntegrity b = this.getBodyIntegrity();
        BodyIntegrity[] values = BodyIntegrity.values();
        int ind = b.ordinal();
        if (ind < values.length - 1) {
            this.setBodyIntegrity(values[ind + 1]);
            return true;
        }
        return false;
    }

    public void setBodyIntegrity(BodyIntegrity bodyIntegrity) {
        byte b = (Byte)this.entityData.get(DATA_FLAGS);
        int ind = bodyIntegrity.ordinal();
        this.entityData.set(DATA_FLAGS, (Object)((byte)(b & 0xF1 | ind << 1)));
    }

    public boolean isOrderedToSit() {
        return ((Byte)this.entityData.get(DATA_FLAGS) & 1) != 0;
    }

    public void setOrderedToSit(boolean sitting) {
        byte b = (Byte)this.entityData.get(DATA_FLAGS);
        if (sitting) {
            this.entityData.set(DATA_FLAGS, (Object)((byte)(b | 1)));
        } else {
            this.entityData.set(DATA_FLAGS, (Object)((byte)(b & 0xFFFFFFFE)));
        }
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(DATA_OWNER_UUID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.entityData.set(DATA_OWNER_UUID, Optional.ofNullable(uuid));
    }

    public boolean canAttack(LivingEntity target) {
        return !this.isOwnedBy(target) && super.canAttack(target);
    }

    public boolean isOwnedBy(LivingEntity entity) {
        return entity == this.getOwner();
    }

    public boolean isAlliedTo(Entity entity) {
        LivingEntity livingEntity = this.getOwner();
        if (entity == livingEntity) {
            return true;
        }
        if (livingEntity != null) {
            return livingEntity.isAlliedTo(entity);
        }
        return super.isAlliedTo(entity);
    }

    public void die(DamageSource damageSource) {
        if (!this.level().isClientSide && this.level().getGameRules().getBoolean(GameRules.RULE_SHOWDEATHMESSAGES) && this.getOwner() instanceof ServerPlayer) {
            this.getOwner().sendSystemMessage(this.getCombatTracker().getDeathMessage());
        }
        super.die(damageSource);
    }

    protected int decreaseAirSupply(int currentAir) {
        return currentAir;
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ModRegistry.GINGERBREAD_COOKIE.get());
    }

    protected void usePlayerItem(Player player, InteractionHand hand, ItemStack stack) {
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        Level level = this.level();
        if (this.isOwnedBy((LivingEntity)player)) {
            if (!player.isSecondaryUseActive() && itemStack.has(DataComponents.FOOD) && this.isFood(itemStack) && this.getHealth() < this.getMaxHealth()) {
                this.usePlayerItem(player, hand, itemStack);
                this.heal(((FoodProperties)itemStack.get(DataComponents.FOOD)).nutrition());
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (player.isSecondaryUseActive()) {
                this.setOrderedToSit(!this.isOrderedToSit());
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        if (this.getBbHeight() > 2.0f) {
            player.startRiding((Entity)this);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (itemStack.is(Items.MILK_BUCKET)) {
            if (!player.getAbilities().instabuild) {
                itemStack.shrink(1);
                Utils.swapItem((Player)player, (InteractionHand)hand, (ItemStack)itemStack, (ItemStack)Items.MILK_BUCKET.getCraftingRemainingItem().getDefaultInstance());
            }
            this.addEffect(new MobEffectInstance(MobEffects.POISON, 900));
            if (player.isCreative() || !this.isInvulnerable()) {
                Vec3 oldMov = this.getDeltaMovement();
                this.hurt(this.damageSources().playerAttack(player), Float.MAX_VALUE);
                this.setDeltaMovement(oldMov);
                this.setForwardDeathAnim(true);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (itemStack.is(ModRegistry.GINGERBREAD_COOKIE.get())) {
            this.increaseIntegrity();
            this.playSound(ModRegistry.GINGERBREAD_BLOCK.get().defaultBlockState().getSoundType().getPlaceSound(), 1.0f, 0.2f);
            itemStack.shrink(1);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (player.canEat(player.isCreative())) {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                Utils.awardAdvancement((ServerPlayer)sp, (ResourceLocation)SnowySpirit.res("husbandry/eat_gingerbread_golem"));
            }
            if (!this.decreaseIntegrity()) {
                this.discard();
            }
            player.playSound(player.getEatingSound(ModRegistry.GINGERBREAD_COOKIE.get().getDefaultInstance()));
            player.getFoodData().eat(1, 0.1f);
            level.gameEvent((Entity)player, (Holder)GameEvent.EAT, this.blockPosition());
            for (int j = 0; j < 15; ++j) {
                level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, ModRegistry.GINGERBREAD_FROSTED_BLOCK.get().defaultBlockState()), this.getRandomX(1.0), this.getRandomY() + 0.2, this.getRandomZ(1.0), 0.0, 0.0, 0.0);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        InteractionResult interactionResult = super.mobInteract(player, hand);
        if (interactionResult.consumesAction()) {
            this.setPersistenceRequired();
        }
        return interactionResult;
    }

    public int getMaxHeadYRot() {
        return 30;
    }

    public boolean doHurtTarget(Entity entity) {
        if (super.doHurtTarget(entity)) {
            this.heal(0.1f);
        }
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 5.0).add(Attributes.ATTACK_DAMAGE, 0.25).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public static enum BodyIntegrity {
        FULL,
        NO_LEFT_HAND,
        NO_HANDS,
        NO_HEAD,
        NO_BODY;

    }
}

