/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.items;

import net.mehvahdjukaar.snowyspirit.common.block.GlowLightsBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class GlowLightsItem
extends Item {
    private final Block block;

    public GlowLightsItem(Block pBlock) {
        super(new Item.Properties());
        this.block = pBlock;
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockState glowLight;
        BlockPos pos;
        Level level;
        BlockState clicked;
        Player player = context.getPlayer();
        if (player != null && player.getAbilities().mayBuild && GlowLightsBlockTile.isValidBlock(clicked = (level = context.getLevel()).getBlockState(pos = context.getClickedPos()), pos, level) && (glowLight = this.block.getStateForPlacement(new BlockPlaceContext(context))) != null) {
            level.setBlockAndUpdate(pos, glowLight);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof GlowLightsBlockTile) {
                GlowLightsBlockTile tile = (GlowLightsBlockTile)blockEntity;
                SoundEvent sound = SoundEvents.AMETHYST_CLUSTER_HIT;
                tile.acceptBlock(clicked);
                level.playSound(player, pos, sound, SoundSource.BLOCKS, 0.9f, 1.3f);
                if (!player.isCreative() && !level.isClientSide()) {
                    context.getItemInHand().shrink(1);
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return InteractionResult.FAIL;
        }
        return super.useOn(context);
    }
}

