/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.dynamicpack;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.misc.IProgressTracker;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicClientResourceProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.PackGenerationStrategy;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HSVColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.mehvahdjukaar.snowyspirit.reg.ModRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ClientDynamicResourcesHandler
extends DynamicClientResourceProvider {
    public static final ClientDynamicResourcesHandler INSTANCE = new ClientDynamicResourcesHandler();
    private static final Map<DyeColor, float[]> COLORS = new EnumMap<DyeColor, float[]>(DyeColor.class);
    private static final List<DyeColor> BRIGHT_COLORS = Arrays.stream(DyeColor.values()).filter(c -> c.ordinal() < 16 && c != DyeColor.BROWN && c != DyeColor.BLACK && c != DyeColor.GRAY && c != DyeColor.LIGHT_GRAY).toList();

    public ClientDynamicResourcesHandler() {
        super(SnowySpirit.res("generated_pack"), PackGenerationStrategy.CACHED);
    }

    public static float[] getGlowLightColor(DyeColor color, RandomSource randomSource) {
        if (color == null) {
            RGBColor c = new HSVColor(randomSource.nextFloat(), 1.0f, 1.0f, 1.0f).asRGB();
            return new float[]{c.red(), c.green(), c.blue()};
        }
        float[] arr = COLORS.get(color);
        if (arr == null) {
            throw new Error("Returned null color. How? " + String.valueOf(color) + " " + String.valueOf(COLORS));
        }
        return arr;
    }

    public void reload(ResourceManager manager, IProgressTracker reporter) {
        super.reload(manager, reporter);
        try {
            List l = SpriteUtils.parsePaletteStrip((ResourceManager)manager, (ResourceLocation)ResType.PARTICLE_TEXTURES.getPath(SnowySpirit.res("glow_lights_colors")), (int)DyeColor.values().length);
            Iterator i = l.iterator();
            for (DyeColor d : DyeColor.values()) {
                if (i.hasNext()) {
                    ClientDynamicResourcesHandler.addColor(d, (Integer)i.next());
                    continue;
                }
                ClientDynamicResourcesHandler.addColor(d, d.getFireworkColor());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void addColor(DyeColor d, int c) {
        int n = (c & 0xFF0000) >> 16;
        int o = (c & 0xFF00) >> 8;
        int p = c & 0xFF;
        COLORS.put(d, new float[]{(float)p / 255.0f, (float)o / 255.0f, (float)n / 255.0f});
    }

    protected Collection<String> gatherSupportedNamespaces() {
        return List.of("snowyspirit");
    }

    protected void regenerateDynamicAssets(Consumer<ResourceGenTask> consumer) {
        consumer.accept(this::regenerateDynamicAssets);
    }

    private void regenerateDynamicAssets(ResourceManager manager, ResourceSink sink) {
        TextureImage template;
        StaticResource itemModel = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.ITEM_MODELS.getPath(SnowySpirit.res("sled_oak")));
        ModRegistry.SLED_ITEMS.forEach((wood, sled) -> {
            try {
                sink.addSimilarJsonResource(manager, itemModel, "sled_oak", wood.getVariantId("sled"));
            }
            catch (Exception ex) {
                SnowySpirit.LOGGER.error("Failed to generate Sled item model for {} : {}", (Object)sled, (Object)ex);
            }
        });
        try {
            template = TextureImage.open((ResourceManager)manager, (ResourceLocation)SnowySpirit.res("entity/sled/oak"));
            try {
                Respriter respriter = Respriter.of((TextureImage)template);
                ModRegistry.SLED_ITEMS.forEach((wood, sled) -> {
                    ResourceLocation textureRes = SnowySpirit.res("entity/sled/" + wood.getTexturePath());
                    if (sink.alreadyHasTextureAtLocation(manager, textureRes)) {
                        return;
                    }
                    try (TextureImage plankTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
                        Palette targetPalette = Palette.fromImage((TextureImage)plankTexture);
                        TextureImage newImage = respriter.recolor(targetPalette);
                        sink.addTexture(textureRes, newImage);
                    }
                    catch (Exception ex) {
                        SnowySpirit.LOGGER.error("Failed to generate sled entity texture for for {} : {}", (Object)sled, (Object)ex);
                    }
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            SnowySpirit.LOGGER.error("Could not generate any sled entity texture : ", (Throwable)ex);
        }
        try {
            template = TextureImage.open((ResourceManager)manager, (ResourceLocation)SnowySpirit.res("item/sleds/sled_oak"));
            try (TextureImage boatMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)SnowySpirit.res("item/sleds/boat_mask"));
                 TextureImage sledMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)SnowySpirit.res("item/sleds/sled_mask"));){
                Palette palette = Palette.fromImage((TextureImage)template, (TextureImage)sledMask);
                Respriter respriter = Respriter.ofPalette((TextureImage)template, (Palette)palette);
                ModRegistry.SLED_ITEMS.forEach((wood, sled) -> {
                    Palette targetPalette;
                    ResourceLocation textureRes = SnowySpirit.res("item/sleds/" + Utils.getID((Item)sled).getPath());
                    if (sink.alreadyHasTextureAtLocation(manager, textureRes)) {
                        return;
                    }
                    TextureImage newImage = null;
                    Item boat = wood.getItemOfThis("boat");
                    if (boat != null) {
                        try (TextureImage vanillaBoat = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstItemTextureLocation((ResourceManager)manager, (Item)boat));){
                            targetPalette = Palette.fromImage((TextureImage)vanillaBoat, (TextureImage)boatMask);
                            newImage = respriter.recolor(targetPalette);
                        }
                        catch (Exception ex) {
                            SnowySpirit.LOGGER.warn("Could not find boat texture for wood type {}. Using plank texture : {}", wood, (Object)ex);
                        }
                    }
                    if (newImage == null) {
                        try (TextureImage plankPalette = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
                            targetPalette = SpriteUtils.extrapolateWoodItemPalette((TextureImage)plankPalette);
                            newImage = respriter.recolor(targetPalette);
                        }
                        catch (Exception ex) {
                            SnowySpirit.LOGGER.error("Failed to generate sled item texture for for {} : {}", (Object)sled, (Object)ex);
                        }
                    }
                    if (newImage != null) {
                        sink.addTexture(textureRes, newImage);
                    }
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            SnowySpirit.LOGGER.error("Could not generate any Sleds item texture : ", (Throwable)ex);
        }
    }

    public void addDynamicTranslations(AfterLanguageLoadEvent lang) {
        ModRegistry.SLED_ITEMS.forEach((wood, sled) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)"item.snowyspirit.sled", (BlockType)wood, (Item)sled));
    }
}

