/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.reg;

import java.util.Arrays;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.mehvahdjukaar.snowyspirit.common.items.SledItem;
import net.mehvahdjukaar.snowyspirit.configs.CommonConfigs;
import net.mehvahdjukaar.snowyspirit.integration.supp.SuppCompat;
import net.mehvahdjukaar.snowyspirit.reg.ModRegistry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ModCreativeTabs {
    public static final RegSupplier<CreativeModeTab> MOD_TAB = CommonConfigs.MOD_TAB.get() == false ? null : RegHelper.registerCreativeModeTab((ResourceLocation)SnowySpirit.res("snowyspirit"), builder -> builder.title((Component)Component.translatable((String)"tab.snowyspirit")).icon(() -> ModRegistry.SLED_ITEMS.get(VanillaWoodTypes.OAK).getDefaultInstance()));

    public static void init() {
        RegHelper.addItemsToTabsRegistration(ModCreativeTabs::registerItemsToTabs);
    }

    public static void registerItemsToTabs(RegHelper.ItemToTabEvent e) {
        ModCreativeTabs.after(e, (ItemStack i) -> i.getItem().components().get(DataComponents.JUKEBOX_PLAYABLE) != null, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, "music_disc_a_carol", ModRegistry.WINTER_DISC);
        ModCreativeTabs.before(e, Items.HONEY_BOTTLE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FOOD_AND_DRINKS, "eggnog", ModRegistry.EGGNOG);
        if (SnowySpirit.SUPPLEMENTARIES_INSTALLED) {
            ModCreativeTabs.after(e, SuppCompat::isCandy, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FOOD_AND_DRINKS, "ginger", ModRegistry.GINGERBREAD_COOKIE);
            ModCreativeTabs.after(e, SuppCompat::isCandy, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FOOD_AND_DRINKS, "candy_cane", ModRegistry.CANDY_CANE);
            ModCreativeTabs.after(e, SuppCompat::isGlobe, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "snow_globe", ModRegistry.SNOW_GLOBE);
        } else {
            ModCreativeTabs.before(e, Items.ROTTEN_FLESH, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FOOD_AND_DRINKS, "ginger", ModRegistry.GINGERBREAD_COOKIE);
            ModCreativeTabs.before(e, Items.ROTTEN_FLESH, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FOOD_AND_DRINKS, "candy_cane", ModRegistry.CANDY_CANE);
            ModCreativeTabs.after(e, Items.BELL, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "snow_globe", ModRegistry.SNOW_GLOBE);
        }
        ModCreativeTabs.after(e, (TagKey<Item>)ItemTags.BOATS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, "sled", (Supplier[])ModRegistry.SLED_ITEMS.values().stream().map(i -> () -> ((SledItem)((Object)i)).asItem()).toArray(Supplier[]::new));
        ModCreativeTabs.before(e, (TagKey<Item>)ItemTags.BANNERS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.COLORED_BLOCKS, "glow_lights", (Supplier[])ModRegistry.GLOW_LIGHTS_ITEMS.values().toArray(Supplier[]::new));
        ModCreativeTabs.before(e, (TagKey<Item>)ItemTags.BANNERS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.COLORED_BLOCKS, "gumdrop", (Supplier[])ModRegistry.GUMDROPS_BUTTONS.values().toArray(Supplier[]::new));
        ModCreativeTabs.before(e, (TagKey<Item>)ItemTags.BANNERS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "glow_lights", (Supplier[])ModRegistry.GLOW_LIGHTS_ITEMS.values().toArray(Supplier[]::new));
        ModCreativeTabs.before(e, (TagKey<Item>)ItemTags.BANNERS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "gumdrop", (Supplier[])ModRegistry.GUMDROPS_BUTTONS.values().toArray(Supplier[]::new));
        ModCreativeTabs.before(e, Items.GLOW_BERRIES, (ResourceKey<CreativeModeTab>)CreativeModeTabs.NATURAL_BLOCKS, "ginger", ModRegistry.GINGER_FLOWER);
        ModCreativeTabs.before(e, Items.WHEAT, (ResourceKey<CreativeModeTab>)CreativeModeTabs.INGREDIENTS, "ginger", ModRegistry.GINGER);
        ModCreativeTabs.after(e, Items.SMALL_DRIPLEAF, (ResourceKey<CreativeModeTab>)CreativeModeTabs.NATURAL_BLOCKS, "ginger", ModRegistry.GINGER_WILD);
        ModCreativeTabs.add(e, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "ginger", ModRegistry.GINGERBREAD_FROSTED_BLOCK, ModRegistry.GINGERBREAD_BLOCK, ModRegistry.GINGERBREAD_STAIRS, ModRegistry.GINGERBREAD_SLAB, ModRegistry.GINGERBREAD_DOOR, ModRegistry.GINGERBREAD_TRAPDOOR);
        ModCreativeTabs.add(e, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "candy_cane", ModRegistry.CANDY_CANE_BLOCK);
        ModCreativeTabs.before(e, Items.BOOKSHELF, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "wreath", ModRegistry.WREATH);
        ModCreativeTabs.add(e, (ResourceKey<CreativeModeTab>)CreativeModeTabs.SPAWN_EGGS, "gingerbread_golem", ModRegistry.GINGERBREAD_GOLEM_EGG);
    }

    private static void after(RegHelper.ItemToTabEvent event, TagKey<Item> target, ResourceKey<CreativeModeTab> tab, String key, Supplier<?> ... items) {
        ModCreativeTabs.after(event, (ItemStack i) -> i.is(target), tab, key, items);
    }

    private static void after(RegHelper.ItemToTabEvent event, Item target, ResourceKey<CreativeModeTab> tab, String key, Supplier<?> ... items) {
        ModCreativeTabs.after(event, (ItemStack i) -> i.is(target), tab, key, items);
    }

    private static void after(RegHelper.ItemToTabEvent event, Predicate<ItemStack> targetPred, ResourceKey<CreativeModeTab> tab, String key, Supplier<?> ... items) {
        if (CommonConfigs.isEnabled(key)) {
            if (MOD_TAB != null) {
                tab = (ResourceKey)MOD_TAB.getHolder().unwrapKey().get();
            }
            ItemLike[] entries = (ItemLike[])Arrays.stream(items).map(s -> (ItemLike)s.get()).toArray(ItemLike[]::new);
            event.addAfter(tab, targetPred, entries);
        }
    }

    private static void before(RegHelper.ItemToTabEvent event, TagKey<Item> target, ResourceKey<CreativeModeTab> tab, String key, Supplier<?> ... items) {
        ModCreativeTabs.before(event, (ItemStack i) -> i.is(target), tab, key, items);
    }

    private static void before(RegHelper.ItemToTabEvent event, Item target, ResourceKey<CreativeModeTab> tab, String key, Supplier<?> ... items) {
        ModCreativeTabs.before(event, (ItemStack i) -> i.is(target), tab, key, items);
    }

    private static void before(RegHelper.ItemToTabEvent event, Predicate<ItemStack> targetPred, ResourceKey<CreativeModeTab> tab, String key, Supplier<?> ... items) {
        if (CommonConfigs.isEnabled(key)) {
            if (MOD_TAB != null) {
                tab = (ResourceKey)MOD_TAB.getHolder().unwrapKey().get();
            }
            ItemLike[] entries = (ItemLike[])Arrays.stream(items).map(s -> (ItemLike)s.get()).toArray(ItemLike[]::new);
            event.addBefore(tab, targetPred, entries);
        }
    }

    private static void add(RegHelper.ItemToTabEvent event, ResourceKey<CreativeModeTab> tab, String key, Supplier<?> ... items) {
        if (CommonConfigs.isEnabled(key)) {
            if (MOD_TAB != null) {
                tab = (ResourceKey)MOD_TAB.getHolder().unwrapKey().get();
            }
            ItemLike[] entries = (ItemLike[])Arrays.stream(items).map(s -> (ItemLike)s.get()).toArray(ItemLike[]::new);
            event.add(tab, entries);
        }
    }
}

