/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.client.model;

import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.amendments.common.tile.ToolHookBlockTile;
import net.mehvahdjukaar.amendments.reg.ModBlockProperties;
import net.mehvahdjukaar.moonlight.api.client.model.BakedQuadsTransformer;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;

public class ToolHookBakedModel
implements CustomBakedModel {
    private final BakedModel tripwireHook;
    private final ItemModelShaper itemModelShaper;
    private final ModelState rotation;

    public ToolHookBakedModel(BakedModel tripwireHook, ModelState state) {
        this.tripwireHook = tripwireHook;
        this.itemModelShaper = Minecraft.getInstance().getItemRenderer().getItemModelShaper();
        this.rotation = state;
    }

    public List<BakedQuad> getBlockQuads(BlockState state, Direction side, RandomSource rand, RenderType renderType, ExtraModelData data) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        try {
            List tripwireQuads = this.tripwireHook.getQuads(state, side, rand);
            Matrix4f mat = new Matrix4f();
            mat.translate(0.0f, 0.3125f, 0.0f);
            BakedQuadsTransformer transformer = BakedQuadsTransformer.create().applyingTransform(mat);
            quads.addAll(transformer.transformAll(tripwireQuads));
        }
        catch (Exception tripwireQuads) {
            // empty catch block
        }
        if (side == null) {
            try {
                boolean fancy = Boolean.TRUE.equals(data.get(ToolHookBlockTile.IS_FANCY));
                ItemStack item = (ItemStack)data.get(ModBlockProperties.ITEM);
                if (!fancy && !item.isEmpty()) {
                    BakedModel itemModel = this.itemModelShaper.getItemModel(item);
                    float scale = 0.75f;
                    Matrix4f mat = new Matrix4f();
                    float x = item.getItem() instanceof DiggerItem ? 0.0625f : 0.0f;
                    mat.mul((Matrix4fc)this.rotation.getRotation().getMatrix());
                    mat.rotate((Quaternionfc)Axis.ZP.rotationDegrees(225.0f));
                    mat.scale(scale, scale, scale);
                    mat.translate(-x, 0.0f, 1.4f / (16.0f * scale));
                    BakedQuadsTransformer transformer = BakedQuadsTransformer.create().applyingTransform(mat);
                    quads.addAll(transformer.transformAll(itemModel.getQuads(null, null, rand)));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return quads;
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean usesBlockLight() {
        return false;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getBlockParticle(ExtraModelData data) {
        return this.tripwireHook.getParticleIcon();
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public ItemTransforms getTransforms() {
        return ItemTransforms.NO_TRANSFORMS;
    }
}

