/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.buuz135.industrial.config.machine.resourceproduction.ResourcefulFurnaceConfig;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.filter.FilterSlot;
import com.hrznstudio.titanium.api.filter.IFilter;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.client.screen.addon.ProgressBarScreenAddon;
import com.hrznstudio.titanium.component.IComponentBundle;
import com.hrznstudio.titanium.component.bundle.LockableInventoryBundle;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.filter.ItemStackFilter;
import com.hrznstudio.titanium.util.InventoryUtil;
import com.hrznstudio.titanium.util.ItemHandlerUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class PotionBrewerTile
extends IndustrialProcessingTile<PotionBrewerTile> {
    @Save
    private SidedFluidTankComponent<PotionBrewerTile> water;
    @Save
    private ProgressBarComponent<PotionBrewerTile> blaze;
    @Save
    private SidedInventoryComponent<PotionBrewerTile> blazeInput;
    @Save
    private SidedInventoryComponent<PotionBrewerTile> bottleInput;
    @Save
    private LockableInventoryBundle<PotionBrewerTile> brewingItems;
    @Save
    private SidedInventoryComponent<PotionBrewerTile> output;
    @Save
    private int state = 0;
    @Save
    private ItemStackFilter filter = new ItemStackFilter("filter", 1){

        public void onContentChanged() {
            super.onContentChanged();
            PotionBrewerTile.this.markForUpdate();
        }
    };

    public PotionBrewerTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleResourceProduction.POTION_BREWER, 100, 38, blockPos, blockState);
        this.addFilter((IFilter)this.filter);
        FilterSlot filterSlot = new FilterSlot(140, 63, 0, (Object)ItemStack.EMPTY);
        filterSlot.setColor(DyeColor.LIME);
        this.filter.setFilter(0, filterSlot);
        this.brewingItems = new LockableInventoryBundle((BasicTile)this, new SidedInventoryComponent("brewingInput", 55, 19, 6, 3).setColor(DyeColor.BLUE).setInputFilter((stack, integer) -> true).setOutputFilter((stack, integer) -> false), 148, 40, false);
        this.addBundle((IComponentBundle)this.brewingItems);
        this.water = (SidedFluidTankComponent)new SidedFluidTankComponent("water", 1000, 75, 40, 0).setColor(DyeColor.CYAN).setTankAction(FluidTankComponent.Action.FILL).setTankType(FluidTankComponent.Type.SMALL).setValidator(fluidStack -> fluidStack.getFluid().isSame((Fluid)Fluids.WATER));
        this.addTank(this.water);
        this.blaze = new ProgressBarComponent<PotionBrewerTile>(30, 20, 100){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new ProgressBarScreenAddon<PotionBrewerTile>(30, 20, (ProgressBarComponent)this){

                    public List<Component> getTooltipLines() {
                        ArrayList<Component> tooltip = new ArrayList<Component>();
                        tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GOLD) + Component.translatable((String)"text.industrialforegoing.display.blaze_fuel").getString() + String.valueOf(ChatFormatting.WHITE) + new DecimalFormat().format(PotionBrewerTile.this.blaze.getProgress()) + String.valueOf(ChatFormatting.GOLD) + "/" + String.valueOf(ChatFormatting.WHITE) + new DecimalFormat().format(PotionBrewerTile.this.blaze.getMaxProgress()))));
                        return tooltip;
                    }
                });
            }
        }.setBarDirection(ProgressBarComponent.BarDirection.VERTICAL_UP).setColor(DyeColor.ORANGE).setCanReset(potionBrewerTile -> false).setCanIncrease(iComponentHarness -> false);
        this.addProgressBar(this.blaze);
        this.blazeInput = (SidedInventoryComponent)new SidedInventoryComponent("blazeInput", 45, 61, 1, 2).setColor(DyeColor.ORANGE).setInputFilter((stack, integer) -> stack.getItem().equals(Items.BLAZE_POWDER)).setOutputFilter((stack, integer) -> false).setSlotToItemStackRender(0, new ItemStack((ItemLike)Items.BLAZE_POWDER));
        this.addInventory((InventoryComponent)this.blazeInput);
        this.bottleInput = (SidedInventoryComponent)new SidedInventoryComponent("bottleInput", 123, 42, 1, 1).setColor(DyeColor.YELLOW).setInputFilter((stack, integer) -> stack.getItem().equals(Items.GLASS_BOTTLE)).setOutputFilter((stack, integer) -> false).setSlotToItemStackRender(0, new ItemStack((ItemLike)Items.GLASS_BOTTLE));
        this.addInventory((InventoryComponent)this.bottleInput);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 82, 64, 3, 4).setColor(DyeColor.MAGENTA).setSlotLimit(1).setInputFilter((stack, integer) -> false).setOutputFilter((stack, integer) -> ((ItemStack)filterSlot.getFilter()).isEmpty() || this.filter.matches(stack));
        this.addInventory((InventoryComponent)this.output);
    }

    @Override
    public boolean canIncrease() {
        if (this.blaze.getProgress() + 20 <= this.blaze.getMaxProgress() && !this.blazeInput.getStackInSlot(0).isEmpty()) {
            this.blazeInput.getStackInSlot(0).shrink(1);
            this.blaze.setProgress(this.blaze.getProgress() + 20);
        }
        if (ItemHandlerUtil.isEmpty(this.output)) {
            this.state = 0;
        }
        if (this.state == 0) {
            return this.water.getFluidAmount() == 1000 && !this.bottleInput.getStackInSlot(0).isEmpty();
        }
        if (this.state >= 7) {
            this.state = 1;
        }
        return this.canBrew(this.state - 1) && this.blaze.getProgress() > 0;
    }

    @Override
    public Runnable onFinish() {
        return () -> {
            if (this.state == 0) {
                int bottleAmount = Math.min(3, this.bottleInput.getStackInSlot(0).getCount());
                for (int i = 0; i < bottleAmount; ++i) {
                    ItemStack stack = new ItemStack((ItemLike)Items.POTION);
                    stack.set(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY.withPotion(Potions.WATER));
                    ItemHandlerHelper.insertItem(this.output, (ItemStack)stack, (boolean)false);
                    this.bottleInput.getStackInSlot(0).shrink(1);
                }
                ++this.state;
            } else {
                this.brewPotions(this.state - 1);
                this.blaze.setProgress(this.blaze.getProgress() - 1);
                ++this.state;
                if (this.state >= 7) {
                    this.state = 1;
                }
            }
        };
    }

    @Override
    public ProgressBarComponent.BarDirection getBarDirection() {
        return ProgressBarComponent.BarDirection.ARROW_DOWN;
    }

    @Override
    protected int getTickPower() {
        return 80;
    }

    public PotionBrewerTile getSelf() {
        return this;
    }

    protected EnergyStorageComponent<PotionBrewerTile> createEnergyStorage() {
        return new EnergyStorageComponent(ResourcefulFurnaceConfig.maxStoredPower, 10, 20);
    }

    private boolean canBrew(int slot) {
        PotionBrewing potionBrewing = this.level.potionBrewing();
        ItemStack ingredient = this.brewingItems.getInventory().getStackInSlot(slot);
        if (ingredient.isEmpty()) {
            return false;
        }
        if (!potionBrewing.isIngredient(ingredient)) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack itemstack1 = this.output.getStackInSlot(i);
            if (itemstack1.isEmpty() || !potionBrewing.hasMix(itemstack1, ingredient)) continue;
            return true;
        }
        return false;
    }

    private void brewPotions(int slot) {
        NonNullList input = NonNullList.create();
        ItemStack ingredient = this.brewingItems.getInventory().getStackInSlot(slot);
        input.addAll((Collection)InventoryUtil.getStacks(this.output));
        if (EventHooks.onPotionAttemptBrew((NonNullList)input)) {
            return;
        }
        input.replaceAll(potionItem -> this.level.potionBrewing().mix(ingredient, potionItem));
        ingredient.shrink(1);
        EventHooks.onPotionBrewed((NonNullList)input);
        for (int i = 0; i < input.size(); ++i) {
            this.output.setStackInSlot(i, (ItemStack)input.get(i));
        }
    }

    @Override
    public void loadSettings(Player player, CompoundTag tag) {
        if (tag.contains("BR_locked")) {
            this.brewingItems.setLocked(tag.getBoolean("BR_locked"));
        }
        if (tag.contains("BR_filter")) {
            for (String psFilter : tag.getCompound("BR_filter").getAllKeys()) {
                this.brewingItems.getFilter()[Integer.parseInt((String)psFilter)] = ItemStack.parseOptional((HolderLookup.Provider)this.level.registryAccess(), (CompoundTag)tag.getCompound("BR_filter").getCompound(psFilter));
            }
        }
        this.filter.deserializeNBT((HolderLookup.Provider)this.level.registryAccess(), tag.getCompound("PB_OutputFilter"));
        super.loadSettings(player, tag);
    }

    @Override
    public void saveSettings(Player player, CompoundTag tag) {
        tag.putBoolean("BR_locked", this.brewingItems.isLocked());
        CompoundTag filterTag = new CompoundTag();
        for (int i = 0; i < this.brewingItems.getFilter().length; ++i) {
            filterTag.put("" + i, this.brewingItems.getFilter()[i].saveOptional((HolderLookup.Provider)this.level.registryAccess()));
        }
        tag.put("BR_filter", (Tag)filterTag);
        tag.put("PB_OutputFilter", (Tag)this.filter.serializeNBT((HolderLookup.Provider)this.level.registryAccess()));
        super.saveSettings(player, tag);
    }
}

