/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.api.xnet.channels;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public enum Color implements StringRepresentable
{
    OFF(0),
    WHITE(0xFFFFFF),
    RED(0xFF0000),
    GREEN(65280),
    BLUE(255),
    YELLOW(0xFFFF00),
    CYAN(65535),
    PURPLE(0xFF00FF),
    ORANGE(0xFF8800),
    GRAY(0x888888),
    DARK_RED(0x880000),
    DARK_GREEN(34816),
    DARK_BLUE(136),
    DARK_YELLOW(0x888800),
    DARK_CYAN(34952),
    DARK_PURPLE(0x880088);

    private final int color;
    private static final Map<Integer, Color> COLOR_MAP;
    public static final Integer[] COLORS;
    public static final Codec<Color> CODEC;
    public static final StreamCodec<FriendlyByteBuf, Color> STREAM_CODEC;

    private Color(int color) {
        this.color = color;
    }

    public int getColor() {
        return this.color;
    }

    public static Color colorByValue(int color) {
        return COLOR_MAP.get(color);
    }

    public String getSerializedName() {
        return this.name();
    }

    static {
        COLOR_MAP = new HashMap<Integer, Color>();
        COLORS = new Integer[Color.values().length];
        CODEC = StringRepresentable.fromEnum(Color::values);
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(Color.class);
        for (int i = 0; i < Color.values().length; ++i) {
            Color col = Color.values()[i];
            Color.COLORS[i] = col.color;
            COLOR_MAP.put(col.color, col);
        }
    }
}

