/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.snuffles.client.model;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import mod.schnappdragon.snuffles.common.entity.animal.Snuffle;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class SnuffleModel<T extends Snuffle>
extends AgeableListModel<T> {
    private final ModelPart body;
    private final ModelPart hump;
    private final ModelPart tongue;
    private final ModelPart horns;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;

    public SnuffleModel(ModelPart part) {
        this.body = part.getChild("body");
        this.hump = this.body.getChild("hump");
        this.tongue = this.body.getChild("tongue");
        this.horns = this.body.getChild("horns");
        this.rightFrontLeg = part.getChild("right_front_leg");
        this.leftFrontLeg = part.getChild("left_front_leg");
        this.rightHindLeg = part.getChild("right_hind_leg");
        this.leftHindLeg = part.getChild("left_hind_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)0.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("hump", CubeListBuilder.create().texOffs(56, 30).addBox(-9.0f, -8.0f, -6.0f, 18.0f, 2.0f, 13.0f), PartPose.ZERO);
        body.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 25).addBox(-9.0f, -6.0f, -10.0f, 18.0f, 11.0f, 20.0f), PartPose.ZERO);
        body.addOrReplaceChild("tongue", CubeListBuilder.create().texOffs(80, 16).addBox(-6.0f, 0.0f, -7.0f, 12.0f, 1.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)-10.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("fluff", CubeListBuilder.create().texOffs(0, 0).addBox(-9.0f, 5.0f, -10.0f, 18.0f, 5.0f, 20.0f), PartPose.ZERO);
        PartDefinition horns = body.addOrReplaceChild("horns", CubeListBuilder.create(), PartPose.ZERO);
        horns.addOrReplaceChild("right_horn", CubeListBuilder.create().texOffs(102, 0).addBox(-3.0f, -7.0f, -6.0f, 3.0f, 8.0f, 8.0f), PartPose.offsetAndRotation((float)-9.0f, (float)-4.0f, (float)-6.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        horns.addOrReplaceChild("left_horn", CubeListBuilder.create().texOffs(80, 0).addBox(0.0f, -7.0f, -6.0f, 3.0f, 8.0f, 8.0f), PartPose.offsetAndRotation((float)9.0f, (float)-4.0f, (float)-6.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-2.5f, 0.0f, -2.5f, 5.0f, 7.0f, 5.0f), PartPose.offsetAndRotation((float)-4.5f, (float)17.0f, (float)-5.5f, (float)0.0f, (float)0.0873f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 7.0f, 5.0f), PartPose.offsetAndRotation((float)4.5f, (float)17.0f, (float)-5.5f, (float)0.0f, (float)-0.0873f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-2.5f, 0.0f, -2.5f, 5.0f, 7.0f, 5.0f), PartPose.offsetAndRotation((float)-4.5f, (float)17.0f, (float)5.5f, (float)0.0f, (float)0.0873f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 7.0f, 5.0f), PartPose.offsetAndRotation((float)4.5f, (float)17.0f, (float)5.5f, (float)0.0f, (float)-0.0873f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    protected Iterable<ModelPart> headParts() {
        return Collections.emptyList();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg, (Object)this.rightHindLeg, (Object)this.leftHindLeg);
    }

    public void prepareMobModel(Snuffle snuffle, float limbSwing, float limbSwingAmount, float partialTick) {
        boolean flag;
        this.horns.visible = flag = !snuffle.isBaby();
        this.hump.visible = flag;
    }

    public void setupAnim(Snuffle snuffle, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (snuffle.isFrosting()) {
            this.body.xRot = -0.0436f + 0.2f * Mth.sin((float)(ageInTicks * 1.2f));
            this.body.zRot = 0.12f * Mth.cos((float)(ageInTicks * 0.6f));
        } else {
            this.body.xRot = -0.0436f + 0.2f * Mth.sin((float)(limbSwing * 0.6f)) * limbSwingAmount;
            this.body.zRot = 0.12f * Mth.cos((float)(limbSwing * 0.2f)) * limbSwingAmount;
        }
        this.rightHindLeg.xRot = Mth.cos((float)(limbSwing * 0.45f)) * 1.5f * limbSwingAmount;
        this.leftHindLeg.xRot = Mth.cos((float)(limbSwing * 0.45f + (float)Math.PI)) * 1.5f * limbSwingAmount;
        this.rightHindLeg.zRot = Mth.cos((float)(limbSwing * 0.45f)) * 0.15f * limbSwingAmount;
        this.leftHindLeg.zRot = Mth.cos((float)(limbSwing * 0.45f + (float)Math.PI)) * 0.15f * limbSwingAmount;
        this.rightFrontLeg.xRot = this.leftHindLeg.xRot;
        this.leftFrontLeg.xRot = this.rightHindLeg.xRot;
        this.rightFrontLeg.zRot = this.rightHindLeg.zRot;
        this.leftFrontLeg.zRot = this.leftHindLeg.zRot;
        this.tongue.xRot = snuffle.isLicking() || snuffle.isFrosting() ? 0.3927f + Mth.sin((float)(ageInTicks * 0.8f)) * 0.2f : 0.3927f + Mth.sin((float)(ageInTicks * 0.12f)) * 0.2f;
    }
}

