/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.snuffles.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mod.schnappdragon.snuffles.client.model.SnuffleModel;
import mod.schnappdragon.snuffles.common.entity.animal.Snuffle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class SnuffleFluffLayer<T extends Snuffle, M extends SnuffleModel<T>>
extends RenderLayer<T, M> {
    private static final Pair<ResourceLocation, ResourceLocation> FLUFF = Pair.of((Object)ResourceLocation.fromNamespaceAndPath((String)"snuffles", (String)"textures/entity/snuffle/snuffle_fluff.png"), (Object)ResourceLocation.fromNamespaceAndPath((String)"snuffles", (String)"textures/entity/snuffle/frosty_fluff.png"));
    private static final Pair<ResourceLocation, ResourceLocation> FLUFF_HORSESHOE = Pair.of((Object)ResourceLocation.fromNamespaceAndPath((String)"snuffles", (String)"textures/entity/snuffle/snuffle_fluff_horseshoe.png"), (Object)ResourceLocation.fromNamespaceAndPath((String)"snuffles", (String)"textures/entity/snuffle/frosty_fluff_horseshoe.png"));
    private static final Pair<ResourceLocation, ResourceLocation> FLUFF_SHEEPDOG = Pair.of((Object)ResourceLocation.fromNamespaceAndPath((String)"snuffles", (String)"textures/entity/snuffle/snuffle_fluff_sheepdog.png"), (Object)ResourceLocation.fromNamespaceAndPath((String)"snuffles", (String)"textures/entity/snuffle/frosty_fluff_sheepdog.png"));

    public SnuffleFluffLayer(RenderLayerParent<T, M> parent) {
        super(parent);
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, T snuffle, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!snuffle.isBaby() && ((Snuffle)((Object)snuffle)).hasFluff()) {
            if (snuffle.isInvisible()) {
                Minecraft minecraft = Minecraft.getInstance();
                boolean flag = minecraft.shouldEntityAppearGlowing(snuffle);
                if (flag) {
                    VertexConsumer vertexconsumer = buffer.getBuffer(RenderType.outline((ResourceLocation)this.getTextureLocation((Snuffle)((Object)snuffle))));
                    ((SnuffleModel)this.getParentModel()).renderToBuffer(matrixStack, vertexconsumer, packedLight, LivingEntityRenderer.getOverlayCoords(snuffle, (float)0.0f), -16777216);
                }
            } else {
                VertexConsumer vertexconsumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureLocation((Snuffle)((Object)snuffle))));
                ((SnuffleModel)this.getParentModel()).renderToBuffer(matrixStack, vertexconsumer, packedLight, LivingEntityRenderer.getOverlayCoords(snuffle, (float)0.0f), -1);
            }
        }
    }

    public ResourceLocation getTextureLocation(Snuffle snuffle) {
        Pair<ResourceLocation, ResourceLocation> fluff = switch (snuffle.getHairstyle()) {
            case Snuffle.Hairstyle.HORSESHOE -> FLUFF_HORSESHOE;
            case Snuffle.Hairstyle.SHEEPDOG -> FLUFF_SHEEPDOG;
            default -> FLUFF;
        };
        return snuffle.isFrosty() ? (ResourceLocation)fluff.getRight() : (ResourceLocation)fluff.getLeft();
    }
}

