/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.snuffles.common.block;

import mod.schnappdragon.snuffles.core.registry.SnufflesBlocks;
import mod.schnappdragon.snuffles.core.registry.SnufflesParticleTypes;
import mod.schnappdragon.snuffles.core.registry.SnufflesSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrostyFluffCarpetBlock
extends CarpetBlock {
    protected static final AABB TOUCH_AABB = new AABB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);

    public FrostyFluffCarpetBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState p_56702_, BlockGetter p_56703_, BlockPos p_56704_, CollisionContext p_56705_) {
        return Shapes.empty();
    }

    @NotNull
    public VoxelShape getBlockSupportShape(BlockState p_56707_, BlockGetter p_56708_, BlockPos p_56709_) {
        return SHAPE;
    }

    @NotNull
    public VoxelShape getVisualShape(BlockState p_56684_, BlockGetter p_56685_, BlockPos p_56686_, CollisionContext p_56687_) {
        return SHAPE;
    }

    public void onCaughtFire(BlockState state, Level world, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        world.setBlock(pos, ((Block)SnufflesBlocks.SNUFFLE_FLUFF_CARPET.get()).defaultBlockState(), 2);
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        AABB aabb;
        if (!(world.isClientSide || entity.isSteppingCarefully() || entity.xOld == entity.getX() && entity.yOld == entity.getY() && entity.zOld == entity.getZ() || world.getRandom().nextInt(16) != 0 || !world.getEntities(null, aabb = TOUCH_AABB.move(pos)).contains(entity))) {
            ((ServerLevel)world).sendParticles((ParticleOptions)((SimpleParticleType)SnufflesParticleTypes.SNOWFLAKE.get()), entity.getX(), entity.getY(), entity.getZ(), 0, (double)(Mth.randomBetween((RandomSource)world.getRandom(), (float)-1.0f, (float)1.0f) * 0.083f), (double)0.05f, (double)(Mth.randomBetween((RandomSource)world.getRandom(), (float)-1.0f, (float)1.0f) * 0.083f), 1.0);
        }
        super.entityInside(state, world, pos, entity);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(Items.MAGMA_CREAM)) {
            if (!world.isClientSide) {
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                world.setBlockAndUpdate(pos, ((Block)SnufflesBlocks.SNUFFLE_FLUFF_CARPET.get()).defaultBlockState());
                world.playSound(null, pos, (SoundEvent)SnufflesSoundEvents.FROSTY_FLUFF_THAW.get(), SoundSource.BLOCKS, 0.7f, 1.6f + (world.random.nextFloat() - world.random.nextFloat()) * 0.4f);
            }
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return super.useItemOn(stack, state, world, pos, player, hand, hitResult);
    }
}

