/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.snuffles.common.entity.animal;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import mod.schnappdragon.snuffles.core.registry.SnufflesBlocks;
import mod.schnappdragon.snuffles.core.registry.SnufflesEntityTypes;
import mod.schnappdragon.snuffles.core.registry.SnufflesParticleTypes;
import mod.schnappdragon.snuffles.core.registry.SnufflesSoundEvents;
import mod.schnappdragon.snuffles.core.tags.SnufflesBlockTags;
import mod.schnappdragon.snuffles.core.tags.SnufflesItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.neoforged.neoforge.common.IShearable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Snuffle
extends Animal
implements IShearable {
    private static final EntityDataAccessor<Integer> FROST_COUNTER = SynchedEntityData.defineId(Snuffle.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_HAIRSTYLE_ID = SynchedEntityData.defineId(Snuffle.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_FLUFF = SynchedEntityData.defineId(Snuffle.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_FROSTY = SynchedEntityData.defineId(Snuffle.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_LICKING = SynchedEntityData.defineId(Snuffle.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int fluffGrowTime = 18000 + this.getRandom().nextInt(6000);

    public Snuffle(EntityType<Snuffle> snuffle, Level world) {
        super(snuffle, world);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(0, (Goal)new SnuffleClimbOnTopOfPowderSnowGoal((Mob)this, this.level()));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new SnuffleTemptGoal(1.1, Ingredient.of(SnufflesItemTags.SNUFFLE_FOOD), false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(5, (Goal)new FrostGoal());
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.6f * this.getEyeHeight()), (double)(this.getBbWidth() * 0.4f));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FROST_COUNTER, (Object)0);
        builder.define(DATA_HAIRSTYLE_ID, (Object)0);
        builder.define(DATA_FLUFF, (Object)false);
        builder.define(DATA_FROSTY, (Object)false);
        builder.define(IS_LICKING, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Hairstyle", this.getHairstyleId());
        compound.putBoolean("HasFluff", this.hasFluff());
        compound.putBoolean("Frosty", this.isFrosty());
        compound.putInt("FluffGrowTime", this.fluffGrowTime);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setHairstyleId(compound.getInt("Hairstyle"));
        this.setFluff(compound.getBoolean("HasFluff"));
        this.setFrosty(compound.getBoolean("Frosty"));
        this.fluffGrowTime = compound.getInt("FluffGrowTime");
    }

    public void setFrostCounter(int counter) {
        this.entityData.set(FROST_COUNTER, (Object)counter);
    }

    public int getFrostCounter() {
        return (Integer)this.entityData.get(FROST_COUNTER);
    }

    public boolean isFrosting() {
        return this.getFrostCounter() > 0;
    }

    public void setHairstyleId(int id) {
        this.entityData.set(DATA_HAIRSTYLE_ID, (Object)id);
    }

    public int getHairstyleId() {
        return Mth.clamp((int)((Integer)this.entityData.get(DATA_HAIRSTYLE_ID)), (int)0, (int)3);
    }

    public Hairstyle getHairstyle() {
        return Hairstyle.getHairstyleById(this.getHairstyleId());
    }

    public void setFluff(boolean hasFluff) {
        this.entityData.set(DATA_FLUFF, (Object)hasFluff);
    }

    public boolean hasFluff() {
        return (Boolean)this.entityData.get(DATA_FLUFF);
    }

    public void setFrosty(boolean isFrosty) {
        this.entityData.set(DATA_FROSTY, (Object)isFrosty);
    }

    public boolean isFrosty() {
        return (Boolean)this.entityData.get(DATA_FROSTY);
    }

    public void setLicking(boolean isLicking) {
        this.entityData.set(IS_LICKING, (Object)isLicking);
    }

    public boolean isLicking() {
        return (Boolean)this.entityData.get(IS_LICKING);
    }

    public void tick() {
        super.tick();
        if (this.isFrosty()) {
            if (this.isOnFire()) {
                this.clearFire();
                this.setFrosty(false);
                this.playEntityOnFireExtinguishedSound();
            }
            if ((this.xOld != this.getX() || this.yOld != this.getY() || this.zOld != this.getZ()) && this.getRandom().nextBoolean()) {
                this.level().addParticle((ParticleOptions)SnufflesParticleTypes.SNOWFLAKE.get(), this.getRandomX(0.4), this.getRandomY(), this.getRandomZ(0.4), 0.0, 0.0, 0.0);
            }
        }
        if (!this.hasFluff() && !this.isBaby()) {
            if (this.fluffGrowTime > 0) {
                --this.fluffGrowTime;
            } else {
                this.setFluff(true);
            }
        }
    }

    private boolean isSnowingAt(Level world, BlockPos pos) {
        if (!world.isRaining()) {
            return false;
        }
        if (!world.canSeeSky(pos)) {
            return false;
        }
        if (world.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos).getY() > pos.getY()) {
            return false;
        }
        return ((Biome)world.getBiome(pos).value()).coldEnoughToSnow(pos);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.is(Items.SLIME_BALL)) {
            if (!this.level().isClientSide) {
                this.usePlayerItem(player, hand, stack);
                this.setHairstyleId((this.getHairstyleId() + 1) % 4);
                this.playSound((SoundEvent)SnufflesSoundEvents.SNUFFLE_STYLE.get(), 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (stack.is(Items.MAGMA_CREAM) && this.isFrosty()) {
            if (!this.level().isClientSide) {
                this.setFrosty(false);
                this.usePlayerItem(player, hand, stack);
                this.playSound((SoundEvent)SnufflesSoundEvents.SNUFFLE_THAW.get(), 0.7f, 1.6f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    protected void usePlayerItem(Player player, InteractionHand hand, ItemStack stack) {
        if (this.isFood(stack)) {
            this.playSound((SoundEvent)SnufflesSoundEvents.SNUFFLE_EAT.get(), 1.0f, 1.0f);
        }
        super.usePlayerItem(player, hand, stack);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SnufflesSoundEvents.SNUFFLE_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SnufflesSoundEvents.SNUFFLE_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SnufflesSoundEvents.SNUFFLE_HURT.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound((SoundEvent)SnufflesSoundEvents.SNUFFLE_STEP.get(), 0.15f, 1.0f);
    }

    public void handleEntityEvent(byte id) {
        if (id == 10) {
            for (int i = 0; i < 4; ++i) {
                this.level().addParticle((ParticleOptions)SnufflesParticleTypes.SNOWFLAKE.get(), this.getRandomX(0.8), this.getEyeY(), this.getRandomZ(0.8), 0.0, 0.1, 0.0);
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    public boolean isShearable(@Nullable Player player, ItemStack item, Level world, BlockPos pos) {
        return this.isAlive() && !this.isBaby() && this.hasFluff();
    }

    @NotNull
    public List<ItemStack> onSheared(@Nullable Player player, ItemStack item, Level world, BlockPos pos) {
        this.setFluff(false);
        this.fluffGrowTime = 18000 + this.getRandom().nextInt(6000);
        this.playSound((SoundEvent)SnufflesSoundEvents.SNUFFLE_SHEAR.get());
        return List.of(new ItemStack(this.isFrosty() ? (ItemLike)SnufflesBlocks.FROSTY_FLUFF.get() : (ItemLike)SnufflesBlocks.SNUFFLE_FLUFF.get()));
    }

    public static boolean checkSnuffleSpawnRules(EntityType<Snuffle> snuffle, LevelAccessor world, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos.below()).is(SnufflesBlockTags.SNUFFLES_SPAWNABLE_ON) && Snuffle.isBrightEnoughToSpawn((BlockAndTintGetter)world, (BlockPos)pos);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        boolean frosty = ((Biome)world.getBiome(this.blockPosition()).value()).coldEnoughToSnow(this.blockPosition());
        if (groupData instanceof SnuffleGroupData) {
            frosty = ((SnuffleGroupData)((Object)groupData)).frosty;
        } else {
            groupData = new SnuffleGroupData(frosty);
        }
        SnuffleGroupData snuffleGroupData = (SnuffleGroupData)((Object)groupData);
        if (snuffleGroupData.getGroupSize() > 0 && this.random.nextFloat() <= snuffleGroupData.getBabySpawnChance()) {
            this.setAge(-24000);
        } else {
            this.setFluff(true);
        }
        this.setFrosty(frosty);
        return super.finalizeSpawn(world, difficulty, spawnType, groupData);
    }

    @Nullable
    public Snuffle getBreedOffspring(ServerLevel world, AgeableMob snuffle) {
        return (Snuffle)((EntityType)SnufflesEntityTypes.SNUFFLE.get()).create((Level)world);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(SnufflesItemTags.SNUFFLE_FOOD);
    }

    public void die(DamageSource source) {
        this.setFrostCounter(0);
        super.die(source);
    }

    class SnuffleClimbOnTopOfPowderSnowGoal
    extends ClimbOnTopOfPowderSnowGoal {
        public SnuffleClimbOnTopOfPowderSnowGoal(Mob mob, Level world) {
            super(mob, world);
        }

        public boolean canUse() {
            boolean flag;
            boolean bl = flag = Snuffle.this.wasInPowderSnow || Snuffle.this.isInPowderSnow;
            if (flag && Snuffle.this.getType().is(EntityTypeTags.POWDER_SNOW_WALKABLE_MOBS)) {
                BlockPos blockpos = Snuffle.this.blockPosition().above();
                BlockState blockstate = Snuffle.this.level().getBlockState(blockpos);
                return blockstate.is(Blocks.POWDER_SNOW) || blockstate.getCollisionShape((BlockGetter)Snuffle.this.level(), blockpos) == Shapes.empty() && Snuffle.this.isFrosty();
            }
            return false;
        }
    }

    class SnuffleTemptGoal
    extends TemptGoal {
        public SnuffleTemptGoal(double speedModifier, Ingredient items, boolean canScare) {
            super((PathfinderMob)Snuffle.this, speedModifier, (Predicate)items, canScare);
        }

        public void start() {
            super.start();
            Snuffle.this.setLicking(true);
        }

        public void stop() {
            super.stop();
            Snuffle.this.setLicking(false);
        }
    }

    class FrostGoal
    extends Goal {
        private static final int WAIT_TIME_BEFORE_FROST = FrostGoal.reducedTickDelay((int)140);
        private int countdown;

        public FrostGoal() {
            this.countdown = Snuffle.this.random.nextInt(WAIT_TIME_BEFORE_FROST);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean canUse() {
            return Snuffle.this.xxa == 0.0f && Snuffle.this.yya == 0.0f && Snuffle.this.zza == 0.0f && this.canFrost();
        }

        public boolean canContinueToUse() {
            return Snuffle.this.isFrosting() && this.canFrost();
        }

        private boolean canFrost() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            Level world = Snuffle.this.level();
            BlockPos pos = Snuffle.this.blockPosition();
            return !Snuffle.this.isFrosty() && (Snuffle.this.isSnowingAt(world, pos) || world.getBlockState(pos).is(Blocks.POWDER_SNOW));
        }

        public void tick() {
            Snuffle.this.setFrostCounter(Math.max(0, Snuffle.this.getFrostCounter() - 1));
            if (Snuffle.this.getFrostCounter() % this.adjustedTickDelay(4) == 0) {
                Snuffle.this.playSound((SoundEvent)SnufflesSoundEvents.SNUFFLE_SHAKE.get(), 1.0f, (Snuffle.this.random.nextFloat() - Snuffle.this.random.nextFloat()) * 0.2f + 1.0f);
                Snuffle.this.setFrosty(Snuffle.this.getFrostCounter() == this.adjustedTickDelay(4));
                Snuffle.this.level().broadcastEntityEvent((Entity)Snuffle.this, (byte)10);
            }
        }

        public void start() {
            Snuffle.this.setFrostCounter(this.adjustedTickDelay(40));
            Snuffle.this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
            Snuffle.this.getNavigation().stop();
        }

        public void stop() {
            Snuffle.this.setFrostCounter(0);
            this.countdown = Snuffle.this.random.nextInt(WAIT_TIME_BEFORE_FROST);
        }
    }

    public static enum Hairstyle {
        DEFAULT,
        SHEEPDOG,
        PORO,
        HORSESHOE;

        private static final Hairstyle[] HAIRSTYLES;

        public static Hairstyle getHairstyleById(int id) {
            return HAIRSTYLES[id];
        }

        static {
            HAIRSTYLES = Hairstyle.values();
        }
    }

    public static class SnuffleGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final boolean frosty;

        public SnuffleGroupData(boolean frosty) {
            super(false);
            this.frosty = frosty;
        }
    }
}

